//
//  NSError+MCAdditions.h
//  MCFoundation
//
//  Created by Fraser Kuyvenhoven on 02/02/09.
//  Copyright 2009 Marketcircle. All rights reserved.
//

#import <Foundation/Foundation.h>


extern NSString *kMCLocalizedShortErrorReasonUserInfoKey;

/*!
 Additions to NSError. Try to use the NSError pattern in as many places as possible.
 To understand our conventions:
 http://wiki.marketcircle.com/groups/engineering/wiki/fa529/Errors.html
 */
@interface NSError (MCAdditions)

+ (NSError *)errorWithLocalizedStringsUsingObject:(id)object domain:(NSString *)domain code:(int)code descriptionArgs:(NSArray *)descriptionArgs recoverySuggestionArgs:(NSArray *)recoverySuggestionArgs failureReasonArgs:(NSArray *)failureReasonArgs underlyingError:(NSError *)underlyingError;

+ (NSError *)errorWithLocalizedStringsUsingObject:(id)object domain:(NSString *)domain code:(int)code;

+ (NSError *)errorWithLocalizedStringsUsingObject:(id)object domain:(NSString *)domain code:(int)code descriptionArgs:(NSArray *)descriptionArgs;

- (NSError *)underlyingError;

// Creates a string by traversing the underlying error concatenating each localized description
- (NSString*)localizedErrorStackDescription;

@end

@interface NSObject (NSErrorMCAdditions)
/*!
 Convenience for converting exceptions
 */
- (NSError *)mcErrorFromException:(NSException *)excep code:(NSInteger)code;
- (NSError *)mcErrorFromString:(NSString *)str code:(NSInteger)code;

@end
